/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.util.Collection;
import org.schemaspy.model.Table;
import org.schemaspy.output.dot.DotConfig;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.FontConfig;
import org.schemaspy.output.dot.schemaspy.StyleSheet;

public class SimpleRuntimeDotConfig
implements RuntimeDotConfig {
    private final FontConfig fontConfig;
    private final DotConfig dotConfig;
    private final boolean relativeLinks;
    private final boolean multiSchema;
    private final StyleSheet styleSheet;

    public SimpleRuntimeDotConfig(FontConfig fontConfig, DotConfig dotConfig, boolean relativeLinks, boolean multiSchema) {
        this.fontConfig = fontConfig;
        this.dotConfig = dotConfig;
        this.relativeLinks = relativeLinks;
        this.multiSchema = multiSchema;
        this.styleSheet = new StyleSheet(dotConfig.getTemplateDirectory(), dotConfig.getCss()).load();
    }

    public boolean isRankDirBugEnabled() {
        return this.dotConfig.isRankDirBugEnabled();
    }

    public String getFont() {
        return this.fontConfig.name();
    }

    public int getFontSize() {
        return this.fontConfig.size();
    }

    public int getTextWidth(String text) {
        return this.fontConfig.widthOfText(text);
    }

    public boolean useRelativeLinks() {
        return this.relativeLinks;
    }

    public boolean isNumRowsEnabled() {
        return this.dotConfig.isNumRowsEnabled();
    }

    public boolean isOneOfMultipleSchemas() {
        return this.multiSchema;
    }

    public StyleSheet styleSheet() {
        return this.styleSheet;
    }

    public boolean showDetails(Collection<Table> table) {
        return table.size() <= this.dotConfig.getMaxDetailedTables();
    }
}

