/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.schemaspy.model.DatabaseObject;
import org.schemaspy.model.ImpliedForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;

public class ImpliedConstraintsFinder {
    private Comparator<TableColumn> byTable = (column1, column2) -> {
        int rc = column1.getTable().compareTo(column2.getTable());
        if (rc == 0) {
            rc = column1.getName().compareToIgnoreCase(column2.getName());
        }
        return rc;
    };

    public List<ImpliedForeignKeyConstraint> find(Collection<Table> tables) {
        List columnsWithoutParents = tables.stream().map(Table::getColumns).flatMap(Collection::stream).filter(arg_0 -> this.noParent(arg_0)).sorted(this.byTable).collect(Collectors.toList());
        Map keyedTablesByPrimary = this.primaryKeys(tables);
        ArrayList<ImpliedForeignKeyConstraint> impliedConstraints = new ArrayList<ImpliedForeignKeyConstraint>();
        for (TableColumn childColumn : columnsWithoutParents) {
            TableColumn parentColumn;
            DatabaseObject columnWithoutParent = new DatabaseObject(childColumn);
            Table primaryTable = this.findPrimaryTable(columnWithoutParent, keyedTablesByPrimary);
            if (primaryTable == null || primaryTable == childColumn.getTable() || (parentColumn = (TableColumn)primaryTable.getPrimaryColumns().get(0)).getParentConstraint(childColumn) != null) continue;
            impliedConstraints.add(new ImpliedForeignKeyConstraint(parentColumn, childColumn));
        }
        return impliedConstraints;
    }

    private boolean noParent(TableColumn column) {
        return !column.isForeignKey() && !column.isPrimary() && column.allowsImpliedParents() && !"LanguageId".equals(column.getName());
    }

    private Map<DatabaseObject, Table> primaryKeys(Collection<Table> tables) {
        TreeMap<DatabaseObject, Table> keyedTablesByPrimary = new TreeMap<DatabaseObject, Table>();
        for (Table table : tables) {
            List tablePrimaries = table.getPrimaryColumns();
            if (tablePrimaries.size() != 1 && !tablePrimaries.stream().anyMatch(t -> "LanguageId".equals(t.getName()))) continue;
            TableColumn tableColumn = (TableColumn)tablePrimaries.get(0);
            DatabaseObject primary = new DatabaseObject(tableColumn);
            if (!tableColumn.allowsImpliedChildren()) continue;
            keyedTablesByPrimary.put(primary, table);
        }
        return keyedTablesByPrimary;
    }

    private Table findPrimaryTable(DatabaseObject columnWithoutParent, Map<DatabaseObject, Table> keyedTablesByPrimary) {
        Table primaryTable = null;
        for (Map.Entry<DatabaseObject, Table> entry : keyedTablesByPrimary.entrySet()) {
            DatabaseObject key = entry.getKey();
            if (!this.nameMatches(columnWithoutParent.getName(), key.getName(), entry.getValue().getName()) || !this.typeMatches(columnWithoutParent, key)) continue;
            if (Objects.nonNull(primaryTable)) {
                return null;
            }
            primaryTable = entry.getValue();
        }
        return primaryTable;
    }

    private boolean nameMatches(String columnWithoutParent, String primaryKey, String primaryKeyTable) {
        return columnWithoutParent.compareToIgnoreCase(primaryKey) == 0 || columnWithoutParent.matches("(?i).*_" + Pattern.quote(primaryKey)) || columnWithoutParent.matches("(?i)" + Pattern.quote(primaryKeyTable) + ".*" + Pattern.quote(primaryKey));
    }

    private boolean typeMatches(DatabaseObject orphan, DatabaseObject primaryKey) {
        return (orphan.getType() != null && primaryKey.getType() != null && orphan.getType().compareTo(primaryKey.getType()) == 0 || orphan.getTypeName().compareToIgnoreCase(primaryKey.getTypeName()) == 0) && orphan.getLength() - primaryKey.getLength() == 0;
    }
}

