/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.xml;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ForeignKeyMeta {
    private final String tableName;
    private final String columnName;
    private final String remoteCatalog;
    private final String remoteSchema;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ForeignKeyMeta(Node foreignKeyNode) {
        NamedNodeMap attribs = foreignKeyNode.getAttributes();
        Node node = attribs.getNamedItem("table");
        if (node == null) {
            throw new IllegalStateException("XML foreignKey definition requires 'table' attribute");
        }
        this.tableName = node.getNodeValue();
        node = attribs.getNamedItem("column");
        if (node == null) {
            throw new IllegalStateException("XML foreignKey definition requires 'column' attribute");
        }
        this.columnName = node.getNodeValue();
        node = attribs.getNamedItem("remoteSchema");
        this.remoteSchema = node == null ? null : node.getNodeValue();
        node = attribs.getNamedItem("remoteCatalog");
        this.remoteCatalog = node == null ? null : node.getNodeValue();
        LOGGER.debug("Found XML FK metadata for {}.{} remoteCatalog: {} remoteSchema: {}", new Object[]{this.tableName, this.columnName, this.remoteCatalog, this.remoteSchema});
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getRemoteCatalog() {
        return this.remoteCatalog;
    }

    public String getRemoteSchema() {
        return this.remoteSchema;
    }

    public String toString() {
        return this.tableName + '.' + this.columnName;
    }
}

