/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import org.schemaspy.model.Catalog;
import org.schemaspy.model.CombinedMap;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.model.Routine;
import org.schemaspy.model.Schema;
import org.schemaspy.model.Sequence;
import org.schemaspy.model.Table;
import org.schemaspy.model.View;
import org.schemaspy.util.CaseInsensitiveMap;

public class Database {
    private final DbmsMeta dbmsMeta;
    private final String databaseName;
    private final Catalog catalog;
    private final Schema schema;
    private final Map<String, Table> tables = new CaseInsensitiveMap();
    private final Map<String, View> views = new CaseInsensitiveMap();
    private final Map<String, Table> remoteTables = new CaseInsensitiveMap();
    private final Map<String, Table> locals = new CombinedMap(this.tables, this.views);
    private final Map<String, Routine> routines = new CaseInsensitiveMap();
    private final ZonedDateTime connectTime = ZonedDateTime.now();
    private final Map<String, Sequence> sequences = new CaseInsensitiveMap();

    public Database(DbmsMeta dbmsMeta, String name, String catalog, String schema) {
        this.dbmsMeta = dbmsMeta;
        this.databaseName = name;
        this.catalog = new Catalog(catalog);
        this.schema = new Schema(schema);
    }

    public DbmsMeta getDbmsMeta() {
        return this.dbmsMeta;
    }

    public String getName() {
        return this.databaseName;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Map<String, Table> getTablesMap() {
        return this.tables;
    }

    public Map<String, Table> getLocals() {
        return this.locals;
    }

    public Collection<View> getViews() {
        return this.views.values();
    }

    public Map<String, View> getViewsMap() {
        return this.views;
    }

    public Collection<Table> getRemoteTables() {
        return this.remoteTables.values();
    }

    public Map<String, Table> getRemoteTablesMap() {
        return this.remoteTables;
    }

    public Collection<Routine> getRoutines() {
        return this.routines.values();
    }

    public Map<String, Routine> getRoutinesMap() {
        return this.routines;
    }

    public Collection<Sequence> getSequences() {
        return this.sequences.values();
    }

    public Map<String, Sequence> getSequencesMap() {
        return this.sequences;
    }

    public String getConnectTime() {
        return this.connectTime.format(DateTimeFormatter.ofPattern("EEE MMM dd HH:mm z yyyy"));
    }

    public String getDatabaseProduct() {
        return this.dbmsMeta.getProductName() + " - " + this.dbmsMeta.getProductVersion();
    }

    public String getRemoteTableKey(String cat, String sch, String table) {
        return Table.getFullName((String)this.getName(), (String)cat, (String)sch, (String)table);
    }
}

