/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.schemaspy.model.TableColumn;

public class TableIndex
implements Comparable<TableIndex> {
    private final String name;
    private final boolean isUnique;
    private Object id;
    private boolean isPrimary;
    private final List<TableColumn> columns = new ArrayList();
    private final List<Boolean> columnsAscending = new ArrayList();

    public TableIndex(String name, boolean unique) {
        this.name = name;
        this.isUnique = unique;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void addColumn(TableColumn column, String sortOrder) {
        if (column != null) {
            this.columns.add(column);
            this.columnsAscending.add(sortOrder == null || "A".equals(sortOrder));
        }
    }

    public String getType() {
        if (this.isPrimaryKey()) {
            return "Primary key";
        }
        if (this.isUnique()) {
            return "Must be unique";
        }
        return "Performance";
    }

    public boolean isPrimaryKey() {
        return this.isPrimary;
    }

    public void setIsPrimaryKey(boolean isPrimaryKey) {
        this.isPrimary = isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public String getColumnsAsString() {
        StringBuilder buf = new StringBuilder();
        for (TableColumn column : this.columns) {
            if (buf.length() > 0) {
                buf.append(" + ");
            }
            buf.append(column);
        }
        return buf.toString();
    }

    public String getSortAsString() {
        StringBuilder buf = new StringBuilder();
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            TableColumn column = (TableColumn)columnsIter.next();
            if (this.isAscending(column)) {
                buf.append("<span title='Ascending'>Asc</span>");
            } else {
                buf.append("<span title='Descending'>Desc</span>");
            }
            if (!columnsIter.hasNext()) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    public List<TableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public boolean isAscending(TableColumn column) {
        return (Boolean)this.columnsAscending.get(this.columns.indexOf(column));
    }

    @Override
    public int compareTo(TableIndex other) {
        if (this.isPrimaryKey() && !other.isPrimaryKey()) {
            return -1;
        }
        if (!this.isPrimaryKey() && other.isPrimaryKey()) {
            return 1;
        }
        Object thisId = this.getId();
        Object otherId = other.getId();
        if (thisId == null || otherId == null) {
            return this.getName().compareToIgnoreCase(other.getName());
        }
        if (thisId instanceof Number) {
            return ((Number)thisId).intValue() - ((Number)otherId).intValue();
        }
        return thisId.toString().compareToIgnoreCase(otherId.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Object thisId = this.getId();
        Object otherId = ((TableIndex)other).getId();
        if (thisId == null || otherId == null) {
            return this.getName().equalsIgnoreCase(((TableIndex)other).getName());
        }
        if (thisId instanceof Number) {
            return thisId.equals(otherId);
        }
        return thisId.toString().equalsIgnoreCase(otherId.toString());
    }

    public int hashCode() {
        Object thisId = this.getId();
        if (thisId == null) {
            return Objects.hash(this.name);
        }
        if (thisId instanceof Number) {
            return Objects.hash(thisId);
        }
        return Objects.hash(thisId.toString().toLowerCase());
    }
}

