/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.schemaspy.output.dot.schemaspy.ResourceFinder;
import org.schemaspy.output.dot.schemaspy.ResourceNotFoundException;
import org.schemaspy.output.dot.schemaspy.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StyleSheet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ResourceFinder resourceFinder = new ResourceFinder();
    private final String templateDirectory;
    private final String cssFile;
    private String bodyBackgroundColor;
    private String tableHeadBackgroundColor;
    private String tableBackgroundColor;
    private String indexedColumnBackgroundColor;
    private String excludedColumnBackgroundColor;

    public StyleSheet(String templateDirectory, String cssFile) {
        this.templateDirectory = templateDirectory;
        this.cssFile = cssFile;
    }

    public StyleSheet load() {
        try {
            if (new File(this.cssFile).exists()) {
                LOGGER.info("Using external StyleSheet file: {}", (Object)this.cssFile);
                this.parseCss(StyleSheet.getContent((Reader)this.getReader(null, this.cssFile)));
            } else {
                this.parseCss(StyleSheet.getContent((Reader)this.getReader(this.templateDirectory, this.cssFile)));
            }
        }
        catch (IOException exc) {
            throw new ParseException("Unable to find css '" + this.cssFile + "' or same file in '" + this.templateDirectory + "'", (Exception)exc);
        }
        return this;
    }

    private void parseCss(String cssContent) {
        String cssNoComments = this.removeComments(cssContent);
        StringTokenizer tokenizer = new StringTokenizer(cssNoComments, "{}");
        String id = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (id == null) {
                id = token.toLowerCase();
                continue;
            }
            Map attribs = StyleSheet.parseAttributes((String)token);
            this.bindAttribute(id, attribs);
            id = null;
        }
    }

    private String removeComments(String cssContent) {
        StringBuilder data = new StringBuilder(cssContent);
        int startComment = data.indexOf("/*");
        while (startComment != -1) {
            int endComment = data.indexOf("*/");
            data.replace(startComment, endComment + "*/".length(), "");
            startComment = data.indexOf("/*");
        }
        return data.toString();
    }

    private void bindAttribute(String id, Map<String, String> attribs) {
        if (".diagram".equals(id)) {
            this.bodyBackgroundColor = attribs.get("background");
        } else if ("th.diagram".equals(id)) {
            this.tableHeadBackgroundColor = attribs.get("background-color");
        } else if ("td.diagram".equals(id)) {
            this.tableBackgroundColor = attribs.get("background-color");
        } else if (".diagram .indexedcolumn".equals(id)) {
            this.indexedColumnBackgroundColor = attribs.get("background");
        } else if (".excludedcolumn".equals(id)) {
            this.excludedColumnBackgroundColor = attribs.get("background");
        }
    }

    private static String getContent(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder data = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            data.append(line);
            data.append(lineSeparator);
        }
        return data.toString();
    }

    private Reader getReader(String parent, String fileName) {
        try {
            InputStream inputStream = this.resourceFinder.find(parent, fileName);
            return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ParseException("Unable to find requested file: " + fileName + " in directory " + parent, (Exception)((Object)rnfe));
        }
    }

    private static Map<String, String> parseAttributes(String data) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        StringTokenizer attrTokenizer = new StringTokenizer(data, ";");
        while (attrTokenizer.hasMoreTokens()) {
            StringTokenizer pairTokenizer = new StringTokenizer(attrTokenizer.nextToken(), ":");
            try {
                String attribute = pairTokenizer.nextToken().trim().toLowerCase();
                String value = pairTokenizer.nextToken().trim().toLowerCase();
                attribs.put(attribute, value);
            }
            catch (NoSuchElementException badToken) {
                LOGGER.warn("Failed to extract attributes from '{}'", (Object)data, (Object)badToken);
            }
        }
        return attribs;
    }

    public String getBodyBackground() {
        if (this.bodyBackgroundColor == null) {
            throw new MissingCssPropertyException(".diagram", "background");
        }
        return this.bodyBackgroundColor;
    }

    public String getTableBackground() {
        if (this.tableBackgroundColor == null) {
            throw new MissingCssPropertyException("td", "background-color");
        }
        return this.tableBackgroundColor;
    }

    public String getTableHeadBackground() {
        if (this.tableHeadBackgroundColor == null) {
            throw new MissingCssPropertyException("th", "background-color");
        }
        return this.tableHeadBackgroundColor;
    }

    public String getIndexedColumnBackground() {
        if (this.indexedColumnBackgroundColor == null) {
            throw new MissingCssPropertyException(".diagram .indexedColumn", "background");
        }
        return this.indexedColumnBackgroundColor;
    }

    public String getExcludedColumnBackgroundColor() {
        if (this.excludedColumnBackgroundColor == null) {
            throw new MissingCssPropertyException(".excludedColumn", "background");
        }
        return this.excludedColumnBackgroundColor;
    }
}

